/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.configurations;

import com.aptana.configurations.ConfigurationsPlugin;
import com.aptana.core.logging.IdeLog;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;

public class ConfigurationsUtil {
    public static boolean evaluateEnablement(Expression expression) {
        if (expression == null) {
            return true;
        }
        SafeEvaluator evaluator = new SafeEvaluator(expression);
        SafeRunner.run((ISafeRunnable)evaluator);
        return evaluator.getResult();
    }

    private static class SafeEvaluator
    implements ISafeRunnable {
        private Expression expression;
        private EvaluationResult result;

        SafeEvaluator(Expression expression) {
            this.expression = expression;
        }

        public boolean getResult() {
            return EvaluationResult.TRUE.equals(this.result);
        }

        public void handleException(Throwable exception) {
            IdeLog.logWarning((Plugin)ConfigurationsPlugin.getDefault(), (String)"Error while evaluating a configuration processor element.", (Throwable)exception);
        }

        public void run() throws Exception {
            this.result = this.expression.evaluate(this.getApplicationContext());
        }

        private IEvaluationContext getApplicationContext() {
            IEvaluationService es = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
            return es == null ? null : es.getCurrentState();
        }
    }
}

